SELECT 
    L_ORDERKEY, 
    SUM(DISCOUNT_PRICE(L_EXTENDEDPRICE, L_DISCOUNT)) AS REVENUE, 
    O_ORDERDATE, 
    O_SHIPPRIORITY
FROM 
    CUSTOMER, 
    ORDERS, 
    LINEITEM
WHERE 
    C_CUSTKEY = O_CUSTKEY 
    AND L_ORDERKEY = O_ORDERKEY 
    AND Q3CONDITIONS(C_MKTSEGMENT, O_ORDERDATE, L_SHIPDATE) = 1
GROUP BY 
    L_ORDERKEY, 
    O_ORDERDATE, 
    O_SHIPPRIORITY
ORDER BY 
    REVENUE DESC NULLS LAST, 
    O_ORDERDATE NULLS FIRST
LIMIT 
    10;